using System;
using System.Web.UI.WebControls;

namespace EasyTabParts
{
	/// <summary>
	/// Summary description for PixelDropDownList.
	/// </summary>
	// This control is used to select line thickness for borders
	// The value is an integer pixel count
	public class PixelDropDownList : DropDownList
	{
		// Constructor - pass in the initial # of pixels
		public PixelDropDownList (int pixels)
		{
			// NOTE: Logic assumes that values are in ascending
			// order and can be converted into integers.
			this.Items.Add (new ListItem ("None", "0"));
			this.Items.Add (new ListItem ("Hairline", "2"));
			this.Items.Add (new ListItem ("Thin", "4"));
			this.Items.Add (new ListItem ("Normal", "6"));
			this.Items.Add (new ListItem ("Medium", "8"));
			this.Items.Add (new ListItem ("Thick", "12"));
			SetPixels (pixels);
		}

		// Public access to the # of pixels
		public int Pixels
		{
			get
			{
				return (Convert.ToInt32(this.SelectedValue));
			}
			set
			{
				SetPixels (value);
			}
		}

		// SetPixels (pixels) - Syncs the control with a pixel count;
		// setting will be rounded down to the next higher setting
		private void SetPixels (int pixels)
		{
			ListItem li = null;
			bool foundItem = false;
			
			// Iterate through the items in the dropdown list
			for (int i=0; i<this.Items.Count && !foundItem; i++)
			{
				// Get this list item and its numeric value
				li = this.Items[i];
				int liPixels = Convert.ToInt32 (li.Value);

				if (pixels > liPixels)
				{
					// If here, this list item is too small;
					// continue to iterate
					li.Selected = false;
				}
				else
				{
					// If here, this list item is large enough;
					// select it and set flag to stop iterating
					li.Selected = true;
					foundItem = true;
				}
			}

			if (!foundItem && li != null)
			{
				// If here, we were asked to set more pixels than our 
				// largest item... set to the largest item
				li.Selected = true;
			}
		}
	}
}
